figure1 = figure('Color',[1 1 1],'rend','painters','pos',[10 10 350 600]);

x1 = cell2mat(nat1_cal_proc(3:end,1));

y1 = cell2mat(nat1_cal_proc(3:end,9));
y2 = cell2mat(nat2_cal_proc(3:end,9));
y3 = cell2mat(nat3_cal_proc(3:end,9));
y4 = cell2mat(rel1_cal_proc(3:end,9));
y5 = cell2mat(rel2_cal_proc(3:end,9)); 
y6 = cell2mat(rel3_cal_proc(3:end,9));

yfit1 = cell2mat(nat1_cal_proc(3:end,3));
yfit2 = cell2mat(nat2_cal_proc(3:end,3));
yfit3 = cell2mat(nat3_cal_proc(3:end,3));
yfit4 = cell2mat(rel1_cal_proc(3:end,3));
yfit5 = cell2mat(rel2_cal_proc(3:end,3)); 
yfit6 = cell2mat(rel3_cal_proc(3:end,3));

hold on

p1 = scatter(x1,y1,'Marker','s');
p2 = scatter(x1,y2,'Marker','s');
p3 = scatter(x1,y3,'Marker','s');
p4 = scatter(x1,y4);
p5 = scatter(x1,y5);
p6 = scatter(x1,y6);
xlim([60 80]);
ylim([-2.5 -0.75]);
 
xy =[60:0.5:80];
fitline1 = interp1(x1,yfit1,xy,'spline');
fitline2 = interp1(x1,yfit2,xy,'spline');
fitline3 = interp1(x1,yfit3,xy,'spline');
fitline4 = interp1(x1,yfit4,xy,'spline');
fitline5 = interp1(x1,yfit5,xy,'spline');
fitline6 = interp1(x1,yfit6,xy,'spline');
l1=line(xy,fitline1);
l2=line(xy,fitline2);
l3=line(xy,fitline3);
l4=line(xy,fitline4);
l5=line(xy,fitline5);
l6=line(xy,fitline6);

l1.Color = p1.CData;
l2.Color = p2.CData;
l3.Color = p3.CData;
l4.Color = p4.CData;
l5.Color = p5.CData;
l6.Color = p6.CData;


text(63, -1.2,'native');

text(63, -2,'released');

set(gca,'FontSize',9);
title('GibbsHelmholtz');
xlabel('Temperature (C)');
ylabel(['\Delta',char(949),'_{(222 nm)}   (M^{-1} cm^{-1})'],'FontSize',12);
set(figure1,'PaperPositionMode','auto');
set(figure1,'PaperSize',[figure1.PaperPosition(3) figure1.PaperPosition(4)]);